<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portfolio | KMK</title>
    <meta content="" name="description" />
    <meta content="" name="keywords" />

    <!-- Favicons -->
    <link href="{{ asset('img/favicon.png') }}" rel="icon" />
    <link href="{{ asset('img/apple-touch-icon.png') }}" rel="apple-touch-icon" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&family=Padauk:wght@400;700&family=Poppins:wght@400;700&display=swap"
        rel="stylesheet">
    <link href="https://use.fontawesome.com/releases/v5.0.6/css/all.css" rel="stylesheet">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="{{ asset('web_assets/css/argon.min.css') }}">
    <link href="{{ asset('vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('web_assets/css/style.css') }}">
    {{-- toastify --}}
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

    @yield('css')
</head>


<body>

    @yield('content')

    <div class="bg-dark p-5 text-center text-white">
        Develop By <a href="{{ url('/') }}" class="text-success">Kaung Myat Kyaw</a>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"
        integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js"
        integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous">
    </script>

    <script src="{{ asset('web_assets/js/argon.min.js') }}"></script>
    {{-- toastify --}}
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

    <script>
        //update cart qty
        const btnCart = $('#btnCart');
        const updateCartQty = cartQty => {
            btnCart.text(cartQty);
        }



        //toast message
        const errorToast = message => {
            Toastify({
                text: message,
                style: {
                    background: "linear-gradient(to right, red, red)",
                },
            }).showToast();
        }

        const successToast = message => {
            Toastify({
                text: message,
                style: {
                    background: "linear-gradient(to right, #2DCE89, #2DCE89)",
                },
            }).showToast();
        }


        $(function() {


            @if (session()->has('error'))
                Toastify({
                    text: "{{ session('error') }}",
                    style: {
                        background: "linear-gradient(to right, red, red)",
                    },
                }).showToast();
            @endif


            @if (session()->has('success'))
                Toastify({
                    text: "{{ session('success') }}",
                    style: {
                        background: "linear-gradient(to right, #2DCE89, #2DCE89)",
                    },
                }).showToast();
            @endif
        });
    </script>

    @yield('script')
</body>

</html>
