<?php

namespace App\Http\Controllers;

use App\Models\About;
use App\Models\Account;
use App\Models\Category;
use App\Models\Fact;
use App\Models\Message;
use App\Models\Project;
use App\Models\Resume;
use App\Models\Service;
use App\Models\Skill;
use App\Models\Social;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function show()
    {
        return view('admin.dashboard',[
            'account'=> Account::where('id',1)->first(),
            'about'=> About::where('id',1)->first()

        ]);
    }
    public function about()
    {
        return view('admin.about',[
            'about'=> About::where('id',1)->first(),
            'facts'=> Fact::all(),
            'skills'=> Skill::all(),
            'categories'=> Category::all(),
            'socials'=> Social::all(),
            'resumes'=> Resume::all(),
            'services'=> Service::all(),
            'projects'=> Project::all(),
            'testimonials'=> Testimonial::all(),
            'messages'=> Message::all(),
        ]);
    }
}
