<?php

namespace App\Http\Controllers;

use App\Models\Account;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Account $account)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Account $account)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Account $account)
        {
            $data = $request->except('image');
        
            // Handle image update
            if ($request->hasFile('image')) {
                // Delete the old image if exists
                if ($account->image) {
                    Storage::delete($account->image);
                }
        
                $image = $request->file('image');
                $imageName = $image->getClientOriginalName();
                $image->storeAs('public/images',$imageName);

                $imagePath = url('storage/images/'.$imageName);
                $data['image'] = $imagePath;
            }
        
            $account->update($data);
        
            return redirect()->back();
        }
        
    

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Account $account)
    {
        //
    }
}
